#!/bin/bash

sh_file_name="train.sh"
gpu="4,6,7"
guid="glasses"


CUDA_VISIBLE_DEVICES=$gpu python main.py --run_train                        \
                        --config celeba.yml                                 \
                        --exp ./runs/visual/$guid                       \
                        --edit_attr $guid                                   \
                        --do_train 1                                        \
                        --do_test 1                                         \
                        --do_alternate 0                                    \
                        --n_train_img 100                                   \
                        --n_test_img 100                                    \
                        --n_iter 1                                          \
                        --bs_train 24                                       \
                        --t_0 999                                           \
                        --n_inv_step 40                                     \
                        --n_train_step 40                                   \
                        --n_test_step 1000                                  \
                        --get_h_num 1                                       \
                        --add_noise_from_xt                                 \
                        --lpips_addnoise_th 1.2                             \
                        --lpips_edit_th 0.33                                \
                        --train_delta_block                                 \
                        --sh_file_name $sh_file_name                        \
                        --save_x0                                           \
                        --save_process_origin                               \
                        --save_process_delta_h                              \
                        --use_x0_tensor                                     \
                        --save_x_origin                                     \
                        --hs_coeff_delta_h 1.0                              \
                        --lr_training 0.5                                   \
                        --clip_loss_w 0.8                                   \
                        --l1_loss_w 3                                       \
                        --save_train_image_step 5                           \
                        --save_checkpoint_during_iter                       \
                        --save_checkpoint_step 20                           \
                        --retrain 1                                         \
                        --save_precomputed_images                           \
                        --model_path ./pretrain_model/celeba_hq.ckpt

